<?php
ob_start();

$origin = $_SERVER["HTTP_ORIGIN"] ?? "";
$allowed = ["https://wdasa.ai", "https://apps.wdasa.ai", "http://localhost:3030"];
if (in_array($origin, $allowed)) {
    header("Access-Control-Allow-Origin: " . $origin);
}
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Access-Control-Allow-Credentials: true");

if ($_SERVER["REQUEST_METHOD"] === "OPTIONS") {
    ob_end_clean();
    http_response_code(200);
    exit;
}

$uri = $_SERVER["REQUEST_URI"];
$path = preg_replace("#^/api#", "", parse_url($uri, PHP_URL_PATH));

$apiUrl = "http://localhost:3001/api" . $path;
$query = $_SERVER["QUERY_STRING"];
if ($query) {
    $apiUrl .= "?" . $query;
}

$method = $_SERVER["REQUEST_METHOD"];
$postData = file_get_contents("php://input");

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
if (!empty($postData)) {
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
}
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, true);

// Forward all headers including cookies
$headers = [];
foreach (getallheaders() as $name => $value) {
    if (strtolower($name) !== "host" && strtolower($name) !== "connection") {
        $headers[] = "$name: $value";
    }
}
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

$response = curl_exec($ch);

if ($response === false) {
    ob_end_clean();
    http_response_code(500);
    header("Content-Type: application/json");
    echo json_encode(["error" => "Proxy error: " . curl_error($ch)]);
    curl_close($ch);
    exit;
}

$headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
$responseHeaders = substr($response, 0, $headerSize);
$responseBody = substr($response, $headerSize);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

ob_end_clean();

// Forward Set-Cookie headers (case-insensitive)
foreach (explode("\r\n", $responseHeaders) as $header) {
    if (stripos($header, "set-cookie:") === 0) {
        $cookie = preg_replace("/^set-cookie:\s*/i", "", $header);
        header("Set-Cookie: " . $cookie, false);
    }
}

http_response_code($httpCode);
header("Content-Type: application/json");
echo $responseBody;
exit;
?>
